<?php
/**
 * iShare 1.2
 * Copyright © 2011 Simon S., All Rights Reserved
 */

// Disallow direct access to this file for security reasons
if(!defined("IN_MYBB"))
{
	die("Direct initialization of this file is not allowed.<br /><br />Please make sure IN_MYBB is defined.");
}

$lang->load("ishare");

$page->add_breadcrumb_item($lang->sharebuttons, "index.php?module=config/sharebuttons");

$sub_tabs['manage_buttons'] = array(
	'title'	=> $lang->tabmanagebuttons,
	'link' => "index.php?module=config/sharebuttons",
	'description' => $lang->tabmanagebuttons_desc
);
	
$sub_tabs['add_button'] = array(
	'title'	=> $lang->tabaddbutton,
	'link' => "index.php?module=config/sharebuttons&amp;action=add",
	'description' => $lang->tabaddbutton_desc
);

$sub_tabs['manage_button_images'] = array(
	'title'	=> $lang->tabmanageicons,
	'link' => "index.php?module=config/sharebuttons&amp;action=manageicons",
	'description' => $lang->tabmanageicons_desc
);

$sub_tabs['add_button_image'] = array(
	'title'	=> $lang->tabuploadicon,
	'link' => "index.php?module=config/sharebuttons&amp;action=uploadicon",
	'description' => $lang->tabuploadicon_desc
);

function check_for_ishare_update () 
{
     global $mybb, $page, $lang;

	 require_once MYBB_ROOT."inc/class_xml.php";
	 
	 if($mybb->version_code >= 1000)
	 {
		 $major_version_code = round($mybb->version_code/100, 0)*100;
	 }
	 else
	 {
		 $major_version_code = round($mybb->version_code/10, 0)*100;
	 }
	 
	 $ishare['guid'] = 'e9353891c38fe091f7c8aff65d5e41de';
	 $ishare['version'] = '1100';
	 
     $contents = fetch_remote_file("http://www.frinklabs.xe.cx/check-updates.php?plugin={$ishare['guid']}&version={$ishare['version']}&mybb={$major_version_code}", $post_data);

     if($contents && $contents !== 'noupdate')
     {
	 	 $parser = new XMLParser($contents);
	     $tree = $parser->get_tree();	
		
		 $lang->newupdateavaible = $lang->sprintf($lang->newupdateavaible, $tree['update']['update_file']['value'], $tree['update']['additional_info']['value']);
		
     	 $page->output_inline_message($lang->newupdateavaible);
     }
}

if($mybb->input['action'] == "add")
{	
	if($mybb->request_method == "post")
	{
		if(!trim($mybb->input['name']))
		{
			$errors[] = $lang->entername;
		}

		if(!trim($mybb->input['url']))
		{
			$errors[] = $lang->enterlink;
		}

		if(!$errors)
		{
			$new_button = array(
				'name' => $db->escape_string($mybb->input['name']),
				'url' => $db->escape_string($mybb->input['url']),
				'icon' => $db->escape_string($mybb->input['image']),
				'active' => $db->escape_string($mybb->input['active']),
				'popup' => $db->escape_string($mybb->input['popup']),
				'popupwidth' => $db->escape_string($mybb->input['popupwidth']),
				'popupheight' => $db->escape_string($mybb->input['popupheight']),
				'disporder' => $db->escape_string($mybb->input['disporder'])
			);

			$bid = $db->insert_query("sharebuttons", $new_button);

			log_admin_action($bid, $mybb->input['name']);

			flash_message($lang->buttonaddedsuccess, 'success');
			admin_redirect('index.php?module=config/sharebuttons');
		}
	}

	$page->add_breadcrumb_item($lang->tabaddbutton);
	$page->output_header($lang->tabaddbutton);

	$page->output_nav_tabs($sub_tabs, 'add_button');
	
	if($errors)
	{
		$page->output_inline_error($errors);
	}
	else
	{
		$mybb->input['path'] = 'images/icons/';
	}

	$form = new Form("index.php?module=config/sharebuttons&amp;action=add", "post", "add");
	$form_container = new FormContainer($lang->tabaddbutton);
	$form_container->output_row($lang->name." <em>*</em>", $lang->name_desc, $form->generate_text_box('name', $mybb->input['name'], array('id' => 'name')), 'name');
	$form_container->output_row($lang->link." <em>*</em>", $lang->link_desc, $form->generate_text_box('url', '', array('id' => 'url')), 'url');
	$form_container->output_row($lang->icon.' (<a href="#" onclick="MyBB.popupWindow(\'index.php?module=config/sharebuttons&action=iconpicker\', \'iconPicker\', 550, 360);">'.$lang->pickicon.'</a>)', '', $form->generate_text_box('image', $mybb->input['image'], array('id' => 'image')), 'image');
	$form_container->output_row($lang->buttonisactive, $lang->copy_settings_and_properties_desc, $form->generate_yes_no_radio('active', 'yes'));
	$form_container->output_row($lang->openinpopup, $lang->copy_settings_and_properties_desc, $form->generate_yes_no_radio('popup', 'no', true, array('id' => 'popup_yes', 'class' => 'popup'), array('id' => 'popup_no', 'class' => 'popup')));
	$form_container->output_row($lang->popupwidth, '', $form->generate_text_box('popupwidth', $mybb->input['popupwidth'], array('id' => 'popupwidth')), 'popupwidth', array(), array('id' => 'row_popupwidth'));
	$form_container->output_row($lang->popupheight, '', $form->generate_text_box('popupheight', $mybb->input['popupheight'], array('id' => 'popupheight')), 'popupheight', array(), array('id' => 'row_popupheight'));
	$form_container->output_row($lang->disporder, '', $form->generate_text_box('disporder', '1', array('id' => 'disporder')), 'disporder');
	$form_container->end();

	$buttons[] = $form->generate_submit_button($lang->save_button);

	$form->output_submit_wrapper($buttons);
	
	$form->end();
	
	echo '<script type="text/javascript" src="./jscripts/peeker.js"></script>
	<script type="text/javascript">
	Event.observe(window, "load", function() {var peeker = new Peeker($$(".popup"), $("row_popupwidth"), /1/, true);var peekertwo = new Peeker($$(".popup"), $("row_popupheight"), /1/, true);});
	</script>';

	$page->output_footer();
}

if($mybb->input['action'] == "edit")
{
	if($mybb->request_method == "post")
	{
		if(!trim($mybb->input['name']))
		{
			$errors[] = $lang->entername;
		}

		if(!trim($mybb->input['url']))
		{
			$errors[] = $lang->enterlink;
		}

		if(!$errors)
		{
			$update_array = array(
				'name' => $db->escape_string($mybb->input['name']),
				'url' => $db->escape_string($mybb->input['url']),
				'icon' => $db->escape_string($mybb->input['image']),
				'active' => $db->escape_string($mybb->input['active']),
				'popup' => $db->escape_string($mybb->input['popup']),
				'popupwidth' => $db->escape_string($mybb->input['popupwidth']),
				'popupheight' => $db->escape_string($mybb->input['popupheight']),
				'disporder' => $db->escape_string($mybb->input['disporder'])
			);

			$db->update_query("sharebuttons", $update_array, "bid = '".$mybb->input['bid']."'");

			log_admin_action($mybb->input['bid'], $mybb->input['name']);

			flash_message($lang->buttoneditedsuccess, 'success');
			admin_redirect('index.php?module=config/sharebuttons');
		}
	}

	$query = $db->simple_select("sharebuttons", "*", "bid='".intval($mybb->input['bid'])."'");
	$button = $db->fetch_array($query);
	
	$page->add_breadcrumb_item($lang->tabeditbutton);
	$page->output_header($lang->tabeditbutton);

	unset($sub_tabs);
	
	$sub_tabs['edit_button'] = array(
	'title' => $lang->tabeditbutton,
	'link' => "index.php?module=config/sharebuttons",
	'description' => $lang->tabeditbutton_desc
    );
	
	$page->output_nav_tabs($sub_tabs, 'edit_button');

	$form = new Form("index.php?module=config/sharebuttons&amp;action=edit&amp;bid=".$mybb->input['bid']."", "post", "add");

	if($errors)
	{
		$page->output_inline_error($errors);
	}
	else
	{
		$mybb->input = $button;
	}	
	
	$form_container = new FormContainer($lang->tabeditbutton);
	$form_container->output_row($lang->name." <em>*</em>", $lang->name_desc, $form->generate_text_box('name', $mybb->input['name'], array('id' => 'name')), 'name');
	$form_container->output_row($lang->link." <em>*</em>", $lang->link_desc, $form->generate_text_box('url', $mybb->input['url'], array('id' => 'url')), 'url');
	$form_container->output_row($lang->icon.' (<a href="#" onclick="MyBB.popupWindow(\'index.php?module=config/sharebuttons&action=iconpicker\', \'iconPicker\', 550, 360);">'.$lang->pickicon.'</a>)', '', $form->generate_text_box('image', $button['icon'], array('id' => 'image')), 'image');
	$form_container->output_row($lang->buttonisactive, $lang->copy_settings_and_properties_desc, $form->generate_yes_no_radio('active', $mybb->input['active']));
	$form_container->output_row($lang->openinpopup, $lang->copy_settings_and_properties_desc, $form->generate_yes_no_radio('popup', $mybb->input['popup'], true, array('id' => 'popup_yes', 'class' => 'popup'), array('id' => 'popup_no', 'class' => 'popup')));
	$form_container->output_row($lang->popupwidth, '', $form->generate_text_box('popupwidth', $mybb->input['popupwidth'], array('id' => 'popupwidth')), 'popupwidth', array(), array('id' => 'row_popupwidth'));
	$form_container->output_row($lang->popupheight, '', $form->generate_text_box('popupheight', $mybb->input['popupheight'], array('id' => 'popupheight')), 'popupheight', array(), array('id' => 'row_popupheight'));
	$form_container->output_row($lang->disporder, '', $form->generate_text_box('disporder', $mybb->input['disporder'], array('id' => 'disporder')), 'disporder');
	$form_container->end();

	$buttons[] = $form->generate_submit_button($lang->save_button);

	$form->output_submit_wrapper($buttons);
	
	$form->end();
	
	echo '<script type="text/javascript" src="./jscripts/peeker.js"></script>
	<script type="text/javascript">
	Event.observe(window, "load", function() {var peeker = new Peeker($$(".popup"), $("row_popupwidth"), /1/, true);var peekertwo = new Peeker($$(".popup"), $("row_popupheight"), /1/, true);});
	</script>';

	$page->output_footer();
}

if($mybb->input['action'] == "manageicons")
{
	if($mybb->request_method == "post")
	{
       if(!empty($mybb->input['images']))
	   {
	       foreach($mybb->input['images'] AS $image) 
	       {
	           if(file_exists(MYBB_ROOT."images/sharebuttons/".$image)) 
		       {
		           if(!unlink(MYBB_ROOT."images/sharebuttons/".$image))
				   {
				   	   $lang->_deleteiconerror = $lang->sprintf($lang->deleteiconerror, $image);
					   $errors[] = $lang->_deleteiconerror;		       
				   } 
				   else
				   {
				       log_admin_action('delete', $image);
				   }
		       }
			   else
			   {
				   $lang->_deleteiconerror = $lang->sprintf($lang->deleteiconerror, $image);
				   $errors[] = $lang->_deleteiconerror;	
			   }
	       }
		   
		   if(!$errors)
	       {			
		       flash_message($lang->icondeletedsuccess, 'success');
		       admin_redirect('index.php?module=config/sharebuttons&action=manageicons');
	       }
	   }	
    }
	
	$page->add_breadcrumb_item($lang->tabmanageicons);
	$page->output_header($lang->tabmanageicons);

	$page->output_nav_tabs($sub_tabs, 'manage_button_images');

	if($errors)
	{
		$page->output_inline_error($errors);
	}
	
	$form = new Form("index.php?module=config/sharebuttons&amp;action=manageicons", "post", "add");
	$form_container = new FormContainer($lang->tabmanageicons);
	
	$dir = opendir(MYBB_ROOT."/images/sharebuttons/");
	
	$image_extensions = array(".jpg", ".gif", ".png", ".bmp");
	$i = 0;
	
	while($file = readdir($dir))
	{	
	    if(in_array(strrchr($file, '.'), $image_extensions)) 
		{	
             $i++;
			 
		     $form_container->output_cell("<input name=\"images[]\" value=\"$file\" type=\"checkbox\">", array("class" => "align_center", "width" => "5px"));
	         $form_container->output_cell("<img src=\"../images/sharebuttons/$file\" style=\"max-height: 30px;\">", array("class" => "align_center"));	
		     
			 $he = $i/6;
			 $he = explode(".", $he);
			 
			 $ii++;
		
		     if(empty($he['1'])) 
			 {			 
			     $ii = 0;				 
	             $form_container->construct_row();			 
			 }				 
		}
	}
	
	switch($ii) 
	{
	  case 5:
		     $form_container->output_cell("");
	         $form_container->output_cell("");	   
	  break;
	  case 4:
		     $form_container->output_cell("");
	         $form_container->output_cell("");	  
	         $form_container->output_cell("");	  
	         $form_container->output_cell("");	  
	  break;
	  case 3:
		     $form_container->output_cell("");
		     $form_container->output_cell("");
	         $form_container->output_cell("");	  
	         $form_container->output_cell("");	  
	         $form_container->output_cell("");	  
	         $form_container->output_cell("");	  
	  break;
	  case 2:
		     $form_container->output_cell("");
		     $form_container->output_cell("");
		     $form_container->output_cell("");
	         $form_container->output_cell("");	  
	         $form_container->output_cell("");	  
	         $form_container->output_cell("");	  
	         $form_container->output_cell("");	  
	         $form_container->output_cell("");	  
	  break;
	  case 1:
		     $form_container->output_cell("");
		     $form_container->output_cell("");
		     $form_container->output_cell("");
		     $form_container->output_cell("");
	         $form_container->output_cell("");	  
	         $form_container->output_cell("");	  
	         $form_container->output_cell("");	  
	         $form_container->output_cell("");	  
	         $form_container->output_cell("");	  
	         $form_container->output_cell("");	  
	  break;
	}
	
	$form_container->construct_row();		
	
	$form_container->end();

	$buttons[] = $form->generate_submit_button($lang->deleteicons_button);

	$form->output_submit_wrapper($buttons);
	
	$form->end();

	$page->output_footer();
}

if($mybb->input['action'] == "uploadicon")
{
	if($mybb->request_method == "post")
	{	
	    $filesize = (int)$_FILES['file']['size'];
	
		if($filesize == 0)
		{
			$error = $lang->errorchoosefile;			
		}
		else
		{		
		    if(file_exists(MYBB_ROOT."/images/sharebuttons/".$_FILES['file']['name']))
		    {
			    $error = $lang->erroralreadyexists;
		    }
			else
			{		
		       if(!move_uploaded_file($_FILES['file']['tmp_name'], MYBB_ROOT."/images/sharebuttons/".$_FILES['file']['name'])) 
		       {
			       $error = $lang->uploadiconerror;
		       }
			}
	    }

		if(!$error)
		{
			log_admin_action('Social Network Button Image', $_FILES['file']['name']);

			flash_message($lang->uploadiconsuccess, 'success');
			admin_redirect('index.php?module=config/sharebuttons&amp;action=manageicons');
		}
	}

	$page->add_breadcrumb_item($lang->tabuploadicon);
	$page->output_header($lang->tabuploadicon);

	$page->output_nav_tabs($sub_tabs, 'add_button_image');

	if($error)
	{
		$page->output_inline_error($error);
	}

	$form = new Form("index.php?module=config/sharebuttons&amp;action=uploadicon", "post", "add", 1);
	$form_container = new FormContainer($lang->tabuploadicon);
	$form_container->output_row($lang->file." <em>*</em>", "", $form->generate_file_upload_box('file', $mybb->input['file'], array('id' => 'file')), 'file');
	$form_container->end();
	
	$form_container = new FormContainer($lang->info);
	$form_container->output_row("", "", $lang->iconuploadinfo);
	$form_container->end();

	$buttons[] = $form->generate_submit_button($lang->upload_button);

	$form->output_submit_wrapper($buttons);
	
	$form->end();

	$page->output_footer();
}

if($mybb->input['action'] == "iconpicker")
{
	global $cp_style;
	
    if(!$cp_style)
    {
	    if(!empty($mybb->settings['cpstyle']) && file_exists(MYBB_ADMIN_DIR."/styles/".$mybb->settings['cpstyle']."/main.css"))
	    {
		    $cp_style = $mybb->settings['cpstyle'];
	    }
	    else
	    {
		    $cp_style = "default";
	    }
    }	
	
	echo "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n";
	echo "<html xmlns=\"http://www.w3.org/1999/xhtml\"{$rtl}>\n";
	echo "<head profile=\"http://gmpg.org/xfn/1\">\n";
	echo "	<title>Choose an image</title>\n";
	echo "	<meta name=\"author\" content=\"frinklabs\" />\n";
    echo "	<meta name=\"copyright\" content=\"Copyright ".COPY_YEAR." frinklabs.\" />\n";
	echo "	<link rel=\"stylesheet\" href=\"styles/".$cp_style."/main.css\" type=\"text/css\" />\n";
		echo "	<script type=\"text/javascript\" src=\"../jscripts/prototype.js\"></script>\n";
		echo "	<script type=\"text/javascript\" src=\"../jscripts/general.js\"></script>\n";
		echo "	<script type=\"text/javascript\" src=\"../jscripts/popup_menu.js\"></script>\n";
		echo "	<script type=\"text/javascript\" src=\"./jscripts/admincp.js\"></script>\n";
		echo "	<script type=\"text/javascript\" src=\"./jscripts/tabs.js\"></script>\n";
	echo "</head>\n";
	echo "<body style=\"padding:0;margin:0;\">\n";
	echo '<script type="text/javascript">
           <!--

           function insertImage(file)
           {
               opener.document.getElementById(\'image\').value = file;
               window.close();
           }

           //-->
          </script>';

	$table = new table;
	
	$dir = opendir(MYBB_ROOT."/images/sharebuttons/");
	
	$image_extensions = array(".jpg", ".gif", ".png", ".bmp");
	$i = 0;
	
	while($file = readdir($dir))
	{	
	    if(in_array(strrchr($file, '.'), $image_extensions)) 
		{	
             $i++;
		
	         $table->construct_cell("<a href=\"javascript:insertImage('images/sharebuttons/$file');\"><img src=\"../images/sharebuttons/$file\" style=\"max-height: 30px;\"></a>", array("class" => "align_center"));	
        
		     $he = $i/4;
			 $he = explode(".", $he);
			 
			 $ii++;
		
		     if(empty($he['1'])) 
			 {
			     $ii = 0;
	             $table->construct_row();			 
			 }			 
		}
	}
	
	switch($ii) 
	{
	  case 3:
		     $table->construct_cell("");
  
	  break;
	  case 2:
		     $table->construct_cell("");
		     $table->construct_cell("");
	  break;
	  case 1:
		     $table->construct_cell("");
		     $table->construct_cell("");
		     $table->construct_cell("");
	  break;
	}
	
	$table->construct_row();	
	
	$table->output($lang->chooseicon);
	
	echo "</body>\n";
	echo "</html>\n";
}

if($mybb->input['action'] == "delete")
{
	$query = $db->simple_select("sharebuttons", "*", "bid='".intval($mybb->input['bid'])."'");
	$icon = $db->fetch_array($query);
	
	if(!$icon['bid'])
	{
		flash_message($lang->buttonnotexist, 'error');
		admin_redirect("index.php?module=config/sharebuttons");
	}

	if($mybb->request_method == "post")
	{
		$db->delete_query("sharebuttons", "bid='{$icon['bid']}'");
	
		log_admin_action($icon['bid'], $icon['name']);

		flash_message($lang->buttondeleted, 'success');
		admin_redirect("index.php?module=config/sharebuttons");
	}
}

if(!$mybb->input['action'])
{
	$page->output_header('Share Buttons');

	$page->output_nav_tabs($sub_tabs, 'manage_buttons');

	if($mybb->settings['ishareupdatecheck'] == '1')
	{
	    check_for_ishare_update();
	}

	if(!empty($mybb->input['disporder']) && is_array($mybb->input['disporder']))
	{
		foreach($mybb->input['disporder'] as $update_bid => $order)
		{
			$db->update_query("sharebuttons", array('disporder' => intval($order)), "bid='".intval($update_bid)."'");
		}
						
		log_admin_action('orders', '0', 'Social Network Buttons');
			
		flash_message($lang->orderupdated, 'success');
		admin_redirect("index.php?module=config/sharebuttons");
	}	
	
	$form = new Form("index.php?module=config/sharebuttons", "post", "sharebuttons");
	
	$form_container = new FormContainer('ادارة ايقونات المشاركة');
	
	$form_container->output_row_header('الصور', array('class' => "align_center", 'width' => 1));
	$form_container->output_row_header($lang->name, array('width' => "70%"));
	$form_container->output_row_header('الترتيب', array('width' => "10px"));
	$form_container->output_row_header($lang->controls, array('class' => "align_center", 'colspan' => 2));

	$query = $db->simple_select("sharebuttons", "*", "", array('order_by' => 'disporder, name'));
	while($icon = $db->fetch_array($query))
	{
		if(my_strpos($icon['icon'], "p://") || substr($icon['icon'], 0, 1) == "/")
		{
			$image = $icon['icon'];
		}
		else
		{
			$image = "../".$icon['icon'];
		}

		$form_container->output_cell("<img src=\"{$image}\" alt=\"\" />", array("class" => "align_center"));
		
		$active = '';
		
		if($icon['active'] == "0") 
		{
		   $active = $lang->not_active;
		}
		
		$form_container->output_cell("{$icon['name']}{$active}");
		
		$form_container->output_cell("<input type=\"text\" name=\"disporder[".$icon['bid']."]\" value=\"".$icon['disporder']."\" class=\"text_input align_center\" style=\"width: 80%; font-weight: bold;\" />");

		$form_container->output_cell("<a href=\"index.php?module=config/sharebuttons&amp;action=edit&amp;bid={$icon['bid']}\">{$lang->edit}</a>", array("class" => "align_center"));
		$form_container->output_cell("<a href=\"index.php?module=config/sharebuttons&amp;action=delete&amp;bid={$icon['bid']}&amp;my_post_key={$mybb->post_code}\" onclick=\"return AdminCP.deleteConfirmation(this, '{$lang->delete_confirm}')\">{$lang->delete}</a>", array("class" => "align_center"));
	
	    $form_container->construct_row();	
	}
	
	$form_container->end();
		
	$buttons[] = $form->generate_submit_button($lang->savebuttonorders);
	$buttons[] = $form->generate_reset_button($lang->reset);
	
	$form->output_submit_wrapper($buttons);
		
	$form->end();

	$page->output_footer();
}
?>